//
//  AnimationSquareView.m
//  DelegateDemo
//
//  Created by 高見龍 on 13/5/26.
//  Copyright (c) 2013年 高思數位網路有限公司. All rights reserved.
//

#import "AnimationSquareView.h"

@implementation AnimationSquareView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self)
    {
        self.backgroundColor = [UIColor blackColor];
    }
    return self;
}

- (void) run
{
    [UIView animateWithDuration:3.0 animations:^{
        CGRect newFrame = CGRectMake(self.frame.origin.x + 150,
                                     self.frame.origin.y,
                                     self.frame.size.width,
                                     self.frame.size.height);
        self.frame = newFrame;
        self.alpha = 0.5;
    } completion:^(BOOL finished) {
        if ([_delegate respondsToSelector:@selector(animationSquareView:didFinishAnimationWithStatus:   )])
        {
            NSDictionary* currentStatus = @{@"status": @"finished"};
            [_delegate animationSquareView:self didFinishAnimationWithStatus:currentStatus];
        }
    }];
}

@end
