//
//  MapDemoViewController.m
//  MapDemo
//
//  Created by eddie on 2012/1/9.
//  Copyright 2012 高思數位網路有限公司. All rights reserved.
//

#import "MapDemoViewController.h"
#import "MyCompany.h"

@implementation MapDemoViewController

- (void)viewDidLoad 
{
    // 建立一個CLLocationCoordinate2D
    CLLocationCoordinate2D mylocation;
    mylocation.latitude = 25.01141;
    mylocation.longitude = 121.42554;
    
    // 建立一個region，待會要設定給MapView
    MKCoordinateRegion kaos_digital;
    
    // 設定經緯度
    kaos_digital.center = mylocation;
    
    // 設定縮放比例
    kaos_digital.span.latitudeDelta = 0.003;
    kaos_digital.span.longitudeDelta = 0.003;
    
    // 準備一個annotation  
    MyCompany *mycompany = [[[MyCompany alloc] initWithCoordinate:mylocation] autorelease];
    mycompany.title = @"高思數位網路";
    mycompany.subtitle = @"媽，我在這裡啦!";
    
    [map_view setRegion:kaos_digital];
    
    // 把annotation加進MapView裡
    [map_view addAnnotation:mycompany];
    
    [super viewDidLoad];

}

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}

- (void)dealloc {
    [super dealloc];
}

@end
